// COPYRIGHT:      &copy; BSOT

// TODO: remove workaround for levelling Android (BT) vs. iPhone (USB)??


/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "spi_tclMySpinAudioGstreamer.h"

player spi_tclMySpinAudioGstreamer::gPlay;
pthread_t spi_tclMySpinAudioGstreamer::gAudioPlayThread = 0;
char* spi_tclMySpinAudioGstreamer::gAudioSrc = NULL;
char* spi_tclMySpinAudioGstreamer::gAudioSink = NULL;
bool spi_tclMySpinAudioGstreamer::gAudioPlaying = FALSE;
bool spi_tclMySpinAudioGstreamer::gFlushAfterEosNeeded = FALSE;

audioStreamConfig spi_tclMySpinAudioGstreamer::gAudioStreamConfig;
audioStreamDeviceType spi_tclMySpinAudioGstreamer::gStreamDeviceType;
audioStreamCallbacks spi_tclMySpinAudioGstreamer::gAudioStreamCallbacks;

gboolean spi_tclMySpinAudioGstreamer::mspin_audio_busCall(GstBus *bus, GstMessage *msg, gpointer data)
{
    //To avoid compiler warning

   spi_tclMySpinAudioGstreamer *poMySpinAudioGstreamer = (spi_tclMySpinAudioGstreamer*)data;

    (void)bus;
    (void)data;
    switch(GST_MESSAGE_TYPE(msg))
    {
        case GST_MESSAGE_EOS:
        {
            /*
            GST_MESSAGE_EOS: end-of-stream reached in a pipeline. The application will
             * only receive this message in the PLAYING state and every time it sets a
             * pipeline to PLAYING that is in the EOS state. The application can perform a
             * flushing seek in the pipeline, which will undo the EOS state again.
             */

            // appsrc
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): appsrc EOS : End of stream",__FUNCTION__ );
            g_main_loop_quit(gPlay.loop);

            break;
        }
        case GST_MESSAGE_STREAM_STATUS:
        {
            GstElement* pOwnerElement = NULL;
            GstStreamStatusType streamStatus;

            gst_message_parse_stream_status(msg, &streamStatus, &pOwnerElement);

            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Stream status event with type=%d for element='%s'",__FUNCTION__, streamStatus, pOwnerElement ? pOwnerElement->object.name : "");       // 0 => create, 1 => enter

            if (pOwnerElement && (0 == strcmp(pOwnerElement->object.name, "src"))
                    && (GST_STREAM_STATUS_TYPE_ENTER == streamStatus))
            {
                spi_tclMySpinAudioGstreamerInternal::mspin_audio_readPads(pOwnerElement);
            }
            break;
        }
        case GST_MESSAGE_NEW_CLOCK:
        {
            GstClock* pClock = NULL;
            gst_message_parse_new_clock(msg, &pClock);

#ifndef GST_VERSION_1
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): New clock event for clock id=%p",__FUNCTION__, pClock ? pClock->clockid : NULL );
#endif
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): New clock, structure: %s",__FUNCTION__, gst_structure_to_string(gst_message_get_structure(msg)) );
            break;
        }
        case GST_MESSAGE_CLOCK_LOST:
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Clock lost => switch to paused",__FUNCTION__ );
            gst_element_set_state(gPlay.pipeline, GST_STATE_PAUSED);
            break;
        }
        case GST_MESSAGE_ASYNC_DONE:
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ASYNC DONE",__FUNCTION__ );
            break;
        }
        case GST_MESSAGE_ERROR:
        {
            gchar  *debug;
            GError *error;

            gst_message_parse_error(msg, &error, &debug);
            g_free(debug);

            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: %s -> stop audio",__FUNCTION__, error->message );

            if (NULL != gAudioStreamCallbacks.fvOnAudioStreamError)
            {
                gAudioStreamCallbacks.fvOnAudioStreamError(1, AUDIO_STREAM_MESSAGE_ERROR, error->message);
            }

            g_error_free(error);

            poMySpinAudioGstreamer->mspin_audio_stop();

            break;
        }
        case GST_MESSAGE_WARNING:
        {
            gchar  *debug;
            GError *error;

            gst_message_parse_warning(msg, &error, &debug);
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): WARNING: %s",__FUNCTION__, error->message );

            if (NULL != gAudioStreamCallbacks.fvOnAudioStreamError)
            {
                gAudioStreamCallbacks.fvOnAudioStreamError(1, AUDIO_STREAM_MESSAGE_WARNING, error->message);
            }

            g_error_free(error);

            break;
        }
        case GST_MESSAGE_BUFFERING :
        {
            gint bufferStatus;
            gint currentBytes = 0;
            gint currentBuffers = 0;
            gint64 currentTime = 0;

            gst_message_parse_buffering(msg, &bufferStatus);

            /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
            /*lint -save -e826*/
            g_object_get(G_OBJECT(gPlay.queue), "current-level-time", &currentTime, NULL);
            g_object_get(G_OBJECT(gPlay.queue), "current-level-bytes", &currentBytes, NULL);
            g_object_get(G_OBJECT(gPlay.queue), "current-level-buffers", &currentBuffers, NULL);
            /*lint -restore */
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): buffering %d percent, timeLevel=%lldns, %d Bytes, %d buffers",__FUNCTION__, bufferStatus, currentTime, currentBytes, currentBuffers );


            break;
        }
        case GST_MESSAGE_STATE_CHANGED :
        {
            GstState l_gstOldState;
            GstState l_gstNewState;
            GstState l_gstPendingState;

            gst_message_parse_state_changed(msg, &l_gstOldState, &l_gstNewState, &l_gstPendingState);
            if (l_gstNewState == l_gstPendingState)
            {
                mspin_log_printLn(eMspinVerbosityInfo, "%s(): New state is same as Pending state (%d)",__FUNCTION__, l_gstNewState );
            }
            else
            {
                if (GST_STATE_PLAYING == l_gstNewState)
                {
                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Got playing state",__FUNCTION__ );
                    //g_timeout_add(200, (GSourceFunc) cb_print_position, pipeline);
                }
                else if (GST_STATE_READY == l_gstNewState)
                {
                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Got ready state",__FUNCTION__ );
                    //gst_element_set_state(GST_ELEMENT(play.pipeline), GST_STATE_PLAYING);
                }
                else if (GST_STATE_PAUSED == l_gstNewState)
                {
                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Got paused state",__FUNCTION__ );

                    if( TRUE == gFlushAfterEosNeeded )
                    {
                        gboolean result;
                        result = gst_element_seek(gPlay.pipeline,1.0,
                                GST_FORMAT_TIME,
                                GST_SEEK_FLAG_FLUSH,
                                GST_SEEK_TYPE_SET, 0LL,
                                GST_SEEK_TYPE_NONE, GST_CLOCK_TIME_NONE);
                        if (!result)
                        {
                            mspin_log_printLn(eMspinVerbosityInfo, "%s(): gst_element_seek() failed",__FUNCTION__ );
                        }
                        gFlushAfterEosNeeded = FALSE;

                        gst_element_set_state(gPlay.pipeline, GST_STATE_PLAYING);
                    }
                }
                else
                {
                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): New state is not same as Pending state (%d)",__FUNCTION__, l_gstNewState );
                }
            }
            break;
        }
        default:
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Other/unknown message=%d",__FUNCTION__, GST_MESSAGE_TYPE(msg) );
            break;
        }
    }

    return TRUE;
}

int spi_tclMySpinAudioGstreamer::mspin_audio_create_pipeline_alsasrc_alsasink(const char *const copocAudioSrc , const char *const copocAudioSink ,
                                               const char *f_pEncoding, int f_iSampleRate,
                                               int f_iChannels, int f_iSampleWidth,
                                               int f_iSampleDepth, bool f_bSigned,
                                               bool f_bEndianness)
{
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Inside",__FUNCTION__ );

    int l_iError = 0;
    GstCaps *l_pCaps = NULL;

    (void)f_pEncoding;
    (void)f_bSigned;
    (void)f_bEndianness;

#ifndef GST_VERSION_1
    const char* media_type = "audio/x-raw-int";
#else
    const char* media_type = "audio/x-raw";
#endif

    //Create pipeline
    gPlay.pipeline = gst_pipeline_new("pipeline");
    if (NULL == gPlay.pipeline)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create pipeline",__FUNCTION__ );
        l_iError = -1;
    }

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating Alsasrc",__FUNCTION__ );
#ifdef X86
    m_pSource = gst_element_factory_make("audiotestsrc", NULL);
#else
    gPlay.audiosrc = gst_element_factory_make("alsasrc", NULL);
#endif

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating AudioQueue",__FUNCTION__ );
    gPlay.queue = gst_element_factory_make("queue", NULL);

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating Alsa Sink",__FUNCTION__ );
    gPlay.audiosink = gst_element_factory_make("alsasink", NULL);

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating Volume",__FUNCTION__ );
    gPlay.volume = gst_element_factory_make("volume", NULL);

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating Capsfilter",__FUNCTION__ );
    gPlay.capsfilter = gst_element_factory_make("capsfilter", NULL);

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Encoding = %s",__FUNCTION__, f_pEncoding );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Rate     = %d",__FUNCTION__, f_iSampleRate );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Channels = %d",__FUNCTION__, f_iChannels );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Width    = %d",__FUNCTION__, f_iSampleWidth );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Depth    = %d",__FUNCTION__, f_iSampleDepth );

    if(f_iSampleRate && f_iChannels && f_iSampleWidth && f_iSampleDepth)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating Caps for alsasrc capsfilter",__FUNCTION__ );
        l_pCaps = gst_caps_new_simple (media_type,
                                       "rate", G_TYPE_INT, f_iSampleRate,
                                       "channels",G_TYPE_INT, f_iChannels,
                                       "width", G_TYPE_INT, f_iSampleWidth,
                                       "depth", G_TYPE_INT, f_iSampleDepth,
                                       NULL);

        if(gPlay.audiosrc && gPlay.capsfilter && l_pCaps && gPlay.queue &&  gPlay.volume &&  gPlay.audiosink
                && copocAudioSrc && copocAudioSink)
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Setting Caps for alsasrc capsfilter",__FUNCTION__ );
            g_object_set((GObject*)gPlay.capsfilter, "caps", l_pCaps, NULL);

            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Creating device path for alsasrc",__FUNCTION__ );
            g_object_set((GObject*)gPlay.audiosrc, "device", copocAudioSrc, NULL);

            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Setting Device path on AudioSink",__FUNCTION__ );
            g_object_set((GObject*)gPlay.audiosink, "device", copocAudioSink, NULL);
            g_object_set((GObject*)gPlay.audiosink, "sync", false, NULL);

            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Adding source, capsfilter, AudioQueue and AudioSink to Pipeline",__FUNCTION__ );
            gst_bin_add_many(GST_BIN (gPlay.pipeline),
                            gPlay.audiosrc,
                            gPlay.capsfilter,
                            gPlay.queue,
                            gPlay.volume,
                            gPlay.audiosink,
                            (const char*)NULL);

            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Linking source, capsfilter, AudioQueue and AudioSink",__FUNCTION__ );
            gst_element_link_many(gPlay.audiosrc,
                            gPlay.capsfilter,
                            gPlay.queue,
                            gPlay.volume,
                            gPlay.audiosink,
                            (const char*)NULL);
            //m_eState = CPlayerEngineEnumerations::LOADINGSTATE;
        }
        else
        {
            l_iError = -2;
        }
    }
    else
    {
        l_iError = -2;
    }

    if(l_iError != 0)
    {
        if(gPlay.audiosrc)
        {
            gst_object_unref(gPlay.audiosrc);
            gPlay.audiosrc = NULL;
        }
        if(gPlay.capsfilter)
        {
            gst_object_unref(gPlay.capsfilter);
            gPlay.capsfilter = NULL;
        }
        if(gPlay.queue)
        {
            gst_object_unref(gPlay.queue);
            gPlay.queue = NULL;
        }
        if(gPlay.volume)
        {
            gst_object_unref(gPlay.volume);
            gPlay.volume = NULL;
        }
        if(gPlay.audiosink)
        {
            gst_object_unref(gPlay.audiosink);
            gPlay.audiosink = NULL;
        }
        if(l_pCaps)
        {
            gst_caps_unref(l_pCaps);
            l_pCaps = NULL;
        }
    }

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Leaving",__FUNCTION__ );

    return l_iError;
}


int spi_tclMySpinAudioGstreamer::mspin_audio_start(const char *audiosrc, const char *audiosink, audioStreamDeviceType stream_dev_type)
{

    pthread_attr_t attr;
    struct sched_param param;
    if (gAudioPlaying)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Audio is already running. Playback isn't started again. Try later",__PRETTY_FUNCTION__ );
        return -1;
    }

    gAudioPlaying = TRUE;

    //Copy audio src and sink string
    if( gAudioSrc != audiosrc )
    {
        if (gAudioSrc)
        {
            free(gAudioSrc);
            gAudioSrc = NULL;
        }
        gAudioSrc = (char*)malloc(strlen(audiosrc)+1);
        strcpy(gAudioSrc, audiosrc);
    }

    if( gAudioSink != audiosink )
    {
        if (gAudioSink)
        {
            free(gAudioSink);
            gAudioSink = NULL;
        }
        gAudioSink = (char*)malloc(strlen(audiosink)+1);
        strcpy(gAudioSink, audiosink);
    }

    gStreamDeviceType = stream_dev_type;

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Using type='%d'",__PRETTY_FUNCTION__, gStreamDeviceType );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Using as src='%s'",__PRETTY_FUNCTION__, gAudioSrc );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Using as sink='%s' in 1 second",__PRETTY_FUNCTION__, gAudioSink );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Using as gAudioPlayThread='%p'",__PRETTY_FUNCTION__, gAudioPlayThread );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Using as gAudioPlaying='%d'",__PRETTY_FUNCTION__, gAudioPlaying );
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Using as gFlushAfterEosNeeded='%d'",__PRETTY_FUNCTION__, gFlushAfterEosNeeded );

    // Set scheduling policy for new thread and the gstreamer threads to SCHED_RR.
    // This improves the behavior, when volume is changed on SUZSLN 15.0F59 base sw.
    // See SUZUKI-26947 for reference
    pthread_attr_init(&attr);
    pthread_attr_setinheritsched(&attr, PTHREAD_EXPLICIT_SCHED);
    pthread_attr_setschedpolicy(&attr, SCHED_RR);

    param.sched_priority = sched_get_priority_min(SCHED_RR);
    pthread_attr_setschedparam(&attr, &param);

    if (0 == pthread_create(&gAudioPlayThread, &attr, spi_tclMySpinAudioGstreamerInternal::mspin_audio_playThread, this))
    {
        pthread_setname_np(gAudioPlayThread, "playAudio");

        return 0;
    }
    else
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Failed to start audio play thread",__PRETTY_FUNCTION__ );
        return -1;
    }

    return 0;
}


void spi_tclMySpinAudioGstreamer::mspin_audio_stop(void)
{
    if (gAudioPlaying)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): -> quit loop (if running)",__PRETTY_FUNCTION__ );

        if (gPlay.loop && g_main_loop_is_running(gPlay.loop))
        {
            g_main_loop_quit(gPlay.loop);
        }
        else
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): WARNING: play loop isn't running",__PRETTY_FUNCTION__ );
        }

        mspin_log_printLn(eMspinVerbosityInfo, "%s(): -> cancel and join audio play thread",__PRETTY_FUNCTION__ );

        if (gAudioPlayThread)
        {
            pthread_join(gAudioPlayThread, NULL);
            gAudioPlayThread = 0;
        }

        if (gAudioSrc)
        {
            free(gAudioSrc);
            gAudioSrc = NULL;
        }

        if (gAudioSink)
        {
            free(gAudioSink);
            gAudioSink = NULL;
        }

        gAudioPlaying = FALSE;

        mspin_log_printLn(eMspinVerbosityInfo, "%s(): done",__PRETTY_FUNCTION__ );
    }
    else
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): Audio isn't running -> nothing to do",__PRETTY_FUNCTION__ );
    }
}


void spi_tclMySpinAudioGstreamer::mspin_audio_set_config(audioStreamConfig config)
{
    gAudioStreamConfig = config;
}


void spi_tclMySpinAudioGstreamer::mspin_audio_set_rate(U32 rate)
{
    mspin_log_printLn(eMspinVerbosityInfo, "%s(%d): ENTER",__PRETTY_FUNCTION__, rate );
    gAudioStreamConfig.sampleRate = rate;
}


void spi_tclMySpinAudioGstreamer::mspin_audio_register_callbacks(U32 cou32Context , audioStreamCallbacks rAudioStreamCallbacks)
{
    (void)cou32Context;            // currently unused
    gAudioStreamCallbacks = rAudioStreamCallbacks;
}


void spi_tclMySpinAudioGstreamer::mspin_audio_handle_rate_changed(U32 u32SampleRate)
{
    if (NULL != gAudioStreamCallbacks.fvOnAudioStreamRateChange)
    {
        gAudioStreamCallbacks.fvOnAudioStreamRateChange(1, u32SampleRate);
    }
}


spi_tclMySpinAudioGstreamer::spi_tclMySpinAudioGstreamer()
{
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): ENTER",__PRETTY_FUNCTION__ );
}


spi_tclMySpinAudioGstreamer::~spi_tclMySpinAudioGstreamer()
{
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): ENTER",__PRETTY_FUNCTION__ );
}
